<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method='html'
doctype-public = "-//W3C//DTD XHTML 1.0 Strict//EN"
doctype-system = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
/>

<!-- param values may be changed during the XSL Transformation -->
<xsl:param name="title">Sample Tree Structure</xsl:param>
<xsl:param name="script">unknown</xsl:param>
<xsl:param name="orderby"></xsl:param>
<xsl:param name="order"></xsl:param>
<xsl:param name="numrows">0</xsl:param>
<xsl:param name="curpage">1</xsl:param>
<xsl:param name="lastpage">1</xsl:param>
<xsl:param name="script_time">0.1234</xsl:param>

<!-- include common templates -->
<xsl:include href="std.head.xsl"/>
<xsl:include href="std.navbar.xsl"/>
<xsl:include href="std.actionbar.xsl"/>
<xsl:include href="std.selectbox.xsl"/>
<xsl:include href="std.message.xsl"/>
<xsl:include href="std.treenode.xsl"/>

<xsl:template match="/"> <!-- standard match to include all child elements -->

  <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <xsl:call-template name="head" />
  <body>
  
  <form method="post" action="{$script}">
  
    <!-- create navigation buttons -->
    <xsl:call-template name="navbar" />
	
    <div id="content">
    
      <h1><xsl:value-of select="$title"/></h1>
	
      <!-- This is the parent table -->
      <table class="parent">
	      <tr class="outer">
	        <td class="outerlabel">Tree Type</td>
	        <td class="outer"><xsl:value-of select="//tree_type[1]/tree_type_desc"/></td>
	      </tr>
      </table>
	
      <!-- this is the child table -->
      <table class="datatable">
        <colgroup class="center" />
        <colgroup width="350" />
	  
	      <thead>
	        <tr>
	          <!-- set up the column headings -->
            <th>Select</th>
	          <th>Node Description</th>
	        </tr>
        </thead>
	  
        <tbody>
	        <!-- add a table row for each non-empty inner record in the XML file -->
	        <xsl:apply-templates select="//tree_node_jnr[count(*)&gt;0]" />
	      </tbody>
	  
      </table>
	
      <!-- look for optional messages -->
      <xsl:call-template name="message"/>
	
      <!-- create standard action buttons -->
      <xsl:call-template name="actbar"/>

    </div>
        
  </form>
  </body>
</html>

</xsl:template>

<xsl:template match="tree_node_jnr">

  <!-- set the row class to 'odd' or 'even' to determine the colour -->
  <tr>
    <xsl:attribute name="class">
      <xsl:choose>
        <xsl:when test="position()mod 2">odd</xsl:when>
        <xsl:otherwise>even</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    
    <td>
      <!-- this cell contains the checkbox to make selections -->
      <xsl:call-template name="selectbox"/>
    </td>

    <!-- these table cells contain the actual data -->
    <td>
      <xsl:call-template name="tree_node">
        <xsl:with-param name="id" select="node_id"/>
        <xsl:with-param name="desc" select="node_desc"/>
        <xsl:with-param name="depth" select="tree_level_seq"/>
        <xsl:with-param name="child_count" select="child_count"/>
        <xsl:with-param name="expanded" select="expanded"/>
      </xsl:call-template>
    </td>
		
  </tr>

</xsl:template>

</xsl:stylesheet>
