<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!--
//*****************************************************************************
// Copyright 2003 by A J Marston <http://www.tonymarston.net>
// Distributed under the GNU General Public Licence
//*****************************************************************************
-->

<xsl:template name="tree_node">
  <xsl:param name="id"/>
  <xsl:param name="desc"/>
  <xsl:param name="depth"/>
  <xsl:param name="child_count"/>
  <xsl:param name="expanded"/>

  <!-- insert a bookmark -->
  <a name="{$id}"></a>
  
  <xsl:call-template name="indent">
    <xsl:with-param name="depth" select="$depth"/>
  </xsl:call-template>
    
  <xsl:choose>
    <xsl:when test="$child_count > 0">
      <!-- insert button for 'expand' or 'collapse', as appropriate -->
      <xsl:choose>
        <xsl:when test="$expanded">
          <!-- item is expanded, so insert 'collapse' button -->
          <a href="{$script}?collapse={$id}#{$id}">
            <img src="images/minus.gif" height="12" width="12" alt="Collapse Thread" class="border0" />
          </a>
        </xsl:when>
        <xsl:otherwise>
          <!-- item is collapsed, so insert 'expand' button -->
          <a href="{$script}?expand={$id}#{$id}">
            <img src="images/plus.gif" height="12" width="12" alt="Expand Thread" class="border0" />
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <!-- no children, so insert blank spacer -->
      <img src="images/spacer.gif" height="12" width="12" />
    </xsl:otherwise>
  </xsl:choose>

  <xsl:text> </xsl:text>
  <xsl:value-of select="$desc" />
  
</xsl:template> <!-- tree_node -->

<xsl:template name="indent">
  <xsl:param name="depth"/>

  <!-- for each of $depth > 1 insert a spacer --> 
  <xsl:if test="$depth > 1">
    
    <xsl:choose>
      <xsl:when test="$depth=2">
        <!-- insert angle symbol -->
        <img src="images/angle.gif" height="16" width="12" alt='angle.gif' />
      </xsl:when>
      <xsl:otherwise>
        <!-- insert spacer -->
        <img src="images/spacer.gif" height="12" width="12" />
      </xsl:otherwise>
    </xsl:choose>
    
    <!-- recursive call with $depth decremented -->
    <xsl:call-template name="indent">
      <xsl:with-param name="depth" select="$depth -1"/>
    </xsl:call-template>
  
  </xsl:if>

</xsl:template> <!-- indent -->

</xsl:stylesheet>